﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="OcenaPodwladniPracownika.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.OcenaPodwladniPracownika" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Przełożeni pracownika</title>
    <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            $("#btnPowrot").button({ icons: { primary: 'ui-icon-arrowreturnthick-1-w' } });
            $("#btnOdswiez").button({ icons: { primary: 'ui-icon-refresh' } });
            $(".btnOtworzGrid").button({ icons: { primary: 'ui-icon-check' } });
        });
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <asp:Label ID="lblError" runat="server"></asp:Label>
            <table class="bodyLRT0" cellspacing="0" cellpadding="0" width="100%" border="0">
                <tr>
                    <td colspan="2" style="font-size: 20px; font-weight: bold;">
                        Podwładni
                    </td>
                    <td style="text-align: right">
                        <asp:LinkButton ID="btnPowrot" runat="server" OnClick="btnPowrot_Click" style="width:90px;">Powrót</asp:LinkButton>
                    </td>
                </tr>
                <tr>
                    <td style="width: 30%; padding-right: 8px;" valign="bottom">
                        <small>
                            <asp:Label ID="lblNazwisko" runat="server">Nazwisko</asp:Label></small><br />
                        <asp:TextBox ID="tbNazwisko" Width="100%" runat="server"></asp:TextBox>
                    </td>
                    <td style="width: 30%; padding-right: 8px;" valign="bottom">
                        <small>
                            <asp:Label ID="lblImie" runat="server">Imię</asp:Label></small><br />
                        <asp:TextBox ID="tbImie" Width="100%" runat="server"></asp:TextBox>
                    </td>
                    <td style="text-align: right" valign="bottom">
                        <asp:LinkButton ID="btnOdswiez" runat="server" OnClick="btnOdswiez_Click" style="width:90px;">Odśwież</asp:LinkButton>
                    </td>
                </tr>
            </table>
            <div>
                <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
                    <div style="float: left; position: absolute; bottom: 2px;">
                        <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
                    </div>
                </div>
                <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="ID_PRACOWNIKA,ID_KTH_ALT,ID_KONTRAHENTA,IMIE,NAZWISKO,WWW_LOGIN,EMAIL,STANOWISKO,JEDNOSTKA" AllowPaging="True" OnRowCommand="gvListy_RowCommand" >
                    <Columns>
                        <asp:TemplateField ShowHeader="False">
                            <ItemTemplate>
                                <asp:LinkButton ID="lbOtworzGrid" class="btnOtworzGrid" runat="server" CausesValidation="false" CommandName="OTWORZ" CommandArgument='<%# Container.DataItemIndex %>' Text="Wybierz"></asp:LinkButton>
                            </ItemTemplate>
                            <ItemStyle VerticalAlign="Middle" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="NAZWISKO" HeaderText="Nazwisko" SortExpression="NAZWISKO" />
                        <asp:BoundField DataField="IMIE" HeaderText="Imię" SortExpression="IMIE" />
                        <asp:BoundField DataField="JEDNOSTKA" HeaderText="Jednostka" SortExpression="JEDNOSTKA" />
                        <asp:BoundField DataField="STANOWISKO" HeaderText="Stanowisko" SortExpression="STANOWISKO" />
                        <asp:BoundField DataField="ID_KONTRAHENTA" HeaderText="CSK" SortExpression="ID_KONTRAHENTA" />
                    </Columns>
                    <PagerSettings Position="Top" />
                    <RowStyle CssClass="TableItem" />
                    <SelectedRowStyle CssClass="TableItemSelected" />
                    <HeaderStyle CssClass="TableHeader" />
                    <AlternatingRowStyle CssClass="TableItemAlt" />
                </asp:GridView>
                <asp:SqlDataSource ID="sdsListy" runat="server" ProviderName="System.Data.SqlClient" SelectCommand="PODWLADNI_ZASTEPOWANI_PRACOWNIKA_STANOWISKA_IKP_LIST" SelectCommandType="StoredProcedure" ConnectionString="" CancelSelectOnNullParameter="False" OnSelected="sdsListy_Selected" OnSelecting="sdsListy_Selecting" >
                    <SelectParameters>
                        <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
                        <asp:SessionParameter Name="P_ID_PRACOWNIKA" SessionField="ID_PRACOWNIKA" />
                        <asp:Parameter Name="P_ID_APLIKACJI" DefaultValue="14F7956D-7848-4629-861C-CCBBA743EF61" />
                        <asp:Parameter Name="P_BEZPOSREDNI" DefaultValue="N" />
                        <asp:Parameter Name="P_UWZGLEDNIAJ_STAN_PODWLADNYCH" DefaultValue="T" />
                        <asp:Parameter Name="P_UWZGLEDNIAJ_INDYWIDUALNYCH_OCENIAJACYCH" DefaultValue="T" />
                        <asp:Parameter Name="P_UMOWY_O_PRACE" />
                        <asp:ControlParameter ControlID="tbNazwisko" Name="P_NAZWISKO" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                        <asp:ControlParameter ControlID="tbImie" Name="P_IMIE" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                    </SelectParameters>
                </asp:SqlDataSource>
            </div>
        </div>
    </form>
</body>
</html>
